#include <string.h>
#include <stdlib.h>
#include <math.h>
#include <float.h>
#include <windows.h>
#include "../MachineInterface.h"
#include "../dsplib/dsplib.h"
#include "overloaderdata.h"
#include "hackstuff.h"
#include "resource.h" 
#pragma optimize ("awy", on)

int library_loaded;
int (__cdecl *oeblib_SERegister)(char *, bool useswave, bool usestick);
int (__cdecl *oeblib_SEUnregister)(char *);
int (__cdecl *oeblib_SESetBuzzCB)(int, CMICallbacks *);
int (__cdecl *oeblib_SESendTick)(int);


CMachineParameter const paraDummy = {
	pt_byte,
	"----------",
	"dummy",
	1,
	0xFE,
	0xFF,
	MPF_STATE,
	16
};

CMachineParameter const paraDummy2 = {
	pt_byte,
	"----------",
	"dummy",
	1,
	0xFE,
	0xFF,
	MPF_STATE,
	16
};

CMachineParameter const paraDummy3 = {
	pt_byte,
	"----------",
	"dummy",
	1,
	0xFE,
	0xFF,
	MPF_STATE,
	16
};


CMachineParameter const *pParameters[] = {
	&paraDummy,
	&paraDummy2,
	&paraDummy3
};

CMachineAttribute const *pAttributes[] = { NULL };


#pragma pack(1)

class gvals
{
public:
	byte dum;
	byte dum2;
	byte dum3;
};

#pragma pack()

CMachineInfo const MacInfo =
{

	MT_GENERATOR,
	MI_VERSION,
	0, //MIF_NO_OUTPUT,
	0,
	0,
	3,
	0,
	pParameters,
	0,
	pAttributes,
	"Generic Song Extender",
	"SongExtend",
	"Edward L. Blake",
	NULL
};


class mi : public CMachineInterface
{
public:
	mi();
	virtual ~mi();
	virtual void Tick();
	virtual void Stop();
	virtual void Init(CMachineDataInput * const pi);
	virtual bool Work(float *psamples, int numsamples, int const mode);
	virtual char const *DescribeValue(int const param, int const value) { if (param == 0) { return "genesongx_img1"; } else { return "----------1"; }; }
public:
	gvals gval;
public:
	CMachine *ThisMachine;
	int my_songextender_index;
};

DLL_EXPORTS

mi::mi()
{
	GlobalVals = &gval;
	if (library_loaded == 1) {
		my_songextender_index = oeblib_SERegister("Generic Song Extender", true, false);
	}
}

mi::~mi() 
{
	if (library_loaded == 1) {
		oeblib_SEUnregister("CyanPhase SongInfo");
	}
}


void mi::Init(CMachineDataInput * const pi)
{
	char buf[20];
	int *blah;
	int i;
	int x,y,y2a,y2b,y2c,y2d,y3a,y3b,za, zb, zc, zd,z2a, z2b;
	ThisMachine = pCB->GetThisMachine();

	CMachine *mastermac = pCB->GetMachine("Master");

	//FindMIOffset (ThisMachine, this);


	if (library_loaded == 1) {
		for (i = 40; i < 80; i++) {
			try {
				x = (int)((int)mastermac + i);
				y = (int)(*((int *)((int)mastermac + i)));
				y2a = 0x000000FF & (int)(*((int *)((int)mastermac + i)));
				y2b = (0x0000FF00 & (int)(*((int *)((int)mastermac + i)))) >> 8;
				y2c = (0x00FF0000 & (int)(*((int *)((int)mastermac + i)))) >> 16;
				y2d = (0xFF000000 & (int)(*((int *)((int)mastermac + i)))) >> 24;
				y3a = 0x0000FFFF & (int)(*((int *)((int)mastermac + i)));
				y3b = (0xFFFF0000 & (int)(*((int *)((int)mastermac + i)))) >> 16;
				if ((y > 500000) && (y < 6000000)) {
					za = 0x000000FF & (int)(*((int *)((int)(*((int *)((int)mastermac + i))))));
					zb = (0x0000FF00 & (int)(*((int *)((int)(*((int *)((int)mastermac + i))))))) >> 8;
					zc = (0x00FF0000 & (int)(*((int *)((int)(*((int *)((int)mastermac + i))))))) >> 16;
					zd = (0xFF000000 & (int)(*((int *)((int)(*((int *)((int)mastermac + i))))))) >> 24;
					z2a = 0x0000FFFF & (int)(*((int *)((int)(*((int *)((int)mastermac + i))))));
					z2b = (0xFFFF0000 & (int)(*((int *)((int)(*((int *)((int)mastermac + i))))))) >> 16;
					sprintf(buf, "%i\n{%i, %i, %i, %i}, {%i, %i}\n{%i, %i, %i, %i}, {%i, %i}", x, y2a, y2b, y2c, y2d, y3a, y3b, za, zb, zc, zd, z2a, z2b);
				} else {
					sprintf(buf, "%i\n{%i, %i, %i, %i}, {%i, %i}\n(no point?)", x, y2a, y2b, y2c, y2d, y3a, y3b);
				}
				MessageBox (NULL, buf, "hh", MB_OK);
			} catch (...) {
				MessageBox (NULL, "tried to point, didn't work", "hh", MB_OK);
			}
		}
	
		oeblib_SESetBuzzCB(my_songextender_index, pCB);
	}
}

void mi::Tick()
{
	if (library_loaded == 1) {
		oeblib_SESendTick(my_songextender_index);
	}
}

bool mi::Work(float *psamples, int numsamples, int const mode)
{
	return false;
}

void mi::Stop()
{
}

HINSTANCE dllInstance;
char myappdir[255];

BOOL WINAPI DllMain ( HANDLE hModule, DWORD fwdreason, LPVOID lpReserved ) {
	switch (fwdreason) {
	case DLL_PROCESS_ATTACH: {
		char baba[256], baba2[256];
		char *filen;

		overloaderdata_initialize();
		overloaderdata_registerimage("genesongx_img1",(HINSTANCE)hModule,"img1");

		dllInstance = (HINSTANCE) hModule;
		GetModuleFileName(dllInstance,baba,256);
		GetFullPathName(baba,256,baba2,&filen);
		sprintf(filen,"\0");
		sprintf(&baba2[(int)(strlen(baba2) - 2 - 15)],"\0");
		sprintf(myappdir,baba2);
		char thestrdata[200];
		sprintf(thestrdata, "%s\\overloader extbuzz.dll", myappdir);
		HMODULE h_dll=LoadLibrary(thestrdata);
		if(h_dll==NULL) {
			library_loaded = 0;
		} else {
			library_loaded = 1;
			oeblib_SERegister=(int (__cdecl *)(char *, bool useswave, bool usestick))GetProcAddress(h_dll,"OEBSERegister");
			oeblib_SEUnregister=(int (__cdecl *)(char *))GetProcAddress(h_dll,"OEBSEUnregister");
			oeblib_SESetBuzzCB=(int (__cdecl *)(int, CMICallbacks *))GetProcAddress(h_dll,"OEBSESetBuzzCB");
			oeblib_SESendTick=(int (__cdecl *)(int))GetProcAddress(h_dll,"OEBSESendTick");
		}


		break;
	}
	case DLL_THREAD_ATTACH: break;
	case DLL_THREAD_DETACH: break;
	case DLL_PROCESS_DETACH: break;
	}
	return TRUE;
}
